//
//  MCCUser.h
//  MCCloud
//
//  Created by Thomas Bartelmess on 24.02.10.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCCUserControllerDelegateProtocol.h"
#import "MCCUser.h"
#import "MCCloudPasswordHelper.h"

/*!
    @class		 MCCUserController
    @abstract    Class for handling information of the MCCloud user account
*/


@interface MCCUserController : NSObject  <MCRestRequestCredentialsProvider> {
	@private
	id <MCCUserControllerDelegate> delegate;
	id <MCCloudPasswordHelper> passwordHelper;
	NSString *_username;
	NSString *_password;
	MCCUser * _user;
}
- (id)initWithUsername:(NSString *)aUsername;
- (id)initWithUsername:(NSString *)aUsername password:(NSString *)aPassword;

- (void)fetchData;
- (void)pushData;
- (void)checkCredentials;

- (void)startUsingService:(NSString *)serviceIdentifier;
- (void)startUsingService:(NSString *)serviceIdentifier onPort:(uint16)port;
- (void)stopUsingService:(NSString *)serviceIdentifier;

- (void)startDefaultServicesForApplication:(NSString *)applicationIdentifier;
- (void)stopAllServicesForApplication:(NSString *)applicationIdentifier;

- (void)startUsingWebservice:(NSString *)webserviceIdentifier usingSSL:(BOOL)useSSL;
- (void)startUsingWebservice:(NSString *)webserviceIdentifier onPort:(uint16)port;
- (void)stopUsingWebservice:(NSString *)webserivceIdentifier;



/*!
    @function	sendPasswordResetRequestForAccount:withResetURLHandler:
    @abstract   Creates a password reset with a given URL Handler
    @discussion Tells the MCCloud that to reset a passwort for a user, MCCloud will send a confirmation E-Mail to the user to verify that it is no fake request. The URL handler is the prefix the the reset url in the e-mail. Make sure the app can handle that url handler
    @param      username username of the user whose password should be resetted.
	@param      urlHandler url handler that is the prefix for the reset url in the email.
*/

- (void)sendPasswordResetRequestForAccount:(NSString *)aUsername 
					   withResetURLHandler:(NSString *)urlHandler;

/*!
	@function	 sendPasswordResetRequestForAccount:withResetURLHandler:
	@abstract   Creates a password reset with a given URL Handler
	@discussion Tells the MCCloud that to reset a passwort for a user, MCCloud will send a confirmation E-Mail to the user to verify that it is no fake. The reset e-mail contains a link to reset the password with the MCCloud web interface.
	@param      username username of the user whose password should be resetted
 */


- (void)sendPasswordResetRequestForAccount:(NSString *)aUsername 
						 usingWebInterface:(BOOL)useWebInterface;

/*!
    @function	resetPasswordForAccount:toPassword:withToken:
    @abstract   Sets a new password with a token
	@discussion NOT IMPLEMENTED YET!
    @param      username username
	@param      password password
    @param      token token
*/

- (void)resetPasswordForAccount:(NSString *)aUsername 
					 toPassword:(NSString *)aPassword 
					  withToken:(NSString *)token;

/*!
	@function	resetPasswordForAccount:toPassword:withToken:
	@abstract   Sets a new password with a token
	@discussion NOT IMPLEMENTED YET!
	@param      username username
	@param      password password
	@param      oldPassword old password
 */

- (void)changePasswordForAccount:(NSString *)aUsername 
					  toPassword:(NSString *)aPassword 
				 withOldPassword:(NSString *)oldPassword;

@property (nonatomic, retain) id <MCCUserControllerDelegate> delegate;
@property (nonatomic, assign) id <MCCloudPasswordHelper> passwordHelper;
@property (nonatomic, retain) NSString *username;
@property (nonatomic, retain) NSString *password;
@property (nonatomic, retain) MCCUser * user;
@end
